﻿using System.Collections.Generic;
using System.IO;

namespace Microscopic_Traffic_Simulator___Model.Utilities
{
    /// <summary>
    /// Class for loading lines of data from text file.
    /// </summary>
    class FileLineDataLoader
    {
        /// <summary>
        /// Path of a file with data.
        /// </summary>
        private string path;

        /// <summary>
        /// Data loader constructor.
        /// </summary>
        /// <param name="path">Path to a file with data.</param>
        internal FileLineDataLoader(string path)
        {
            this.path = path;
        }

        /// <summary>
        /// Function for retrieving data from file.
        /// </summary>
        /// <returns>Lines of data.</returns>
        internal IEnumerable<string[]> GetLinesWithData()
        {
            using (StreamReader sr = new StreamReader(path))
            {
                string line;
                while (!string.IsNullOrEmpty(line = sr.ReadLine()))
                {
                    yield return line.Split();
                }
            }
        }
    }
}
